// Copyright 1998 Macromedia, Inc. All rights reserved.

//*************** GLOBAL VARS  *****************

var helpDoc = MM.HELP_behShowHideLayers;

//******************* BEHAVIOR FUNCTION **********************

//Shows and/or hides a number of layers at the same time.
//Accepts a variable number of args, in triplets as follows:
//  objName  - simple name of object, such as "Layer1". Older calls accepted: "document.layers['Layer1']"
//  x        - ignored (for backward compatibility)
//  visStr   - hide, show, or inherit, the Netscape visibility value. This values are
//             converted based on the current browser. IE uses visible, hidden, inherit.
//
//This function can make a whole set of layers visible while hiding others.
//Uses MM_findObj() to resolve browser differences.
//For Netscape, essentially calls
//   document.layers['myLayer'].visibility = 'show'
//For IE, essentially call
//   document.all['myLayer'].style.visibility = 'visible'
//Fails gracefully on older browsers by ensuring the layers and the particular layer exists.

function MM_showHideLayers() { //v3.0
  var i,p,v,obj,args=MM_showHideLayers.arguments;
  for (i=0; i<(args.length-2); i+=3) if ((obj=MM_findObj(args[i]))!=null) { v=args[i+2];
    if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v='hide')?'hidden':v; }
    obj.visibility=v; }
}

MM.VERSION_MM_showHideLayers = 3.0; //define latest version number for behavior inspector

//******************* API **********************


//Checks for the existence of layers.
//If none exist, returns false so this Action is grayed out.

function canAcceptBehavior(){
  var nameArray = getAllObjectRefs("NS 4.0","LAYER");  //get layer names (includes CSS)
  return (nameArray.length > 0);
}



//Returns a Javascript function to be inserted in HTML head with script tags.

function behaviorFunction(){
  return "MM_findObj,MM_showHideLayers";
}



//Returns fn call to insert in HTML tag <TAG... onEvent='thisFn(arg)'>
//Gets list of layers from doc property. With each layer, it gets the parallel
//frame name from select 'menu'. Each theVis & layerObj refs are embedded as arguments.

function applyBehavior() {
  var visArray,i,theVis,layerObjNS,argList = "", retVal="";

  visArray = document.MM_visArray;           //get global list of visibilities
  for (i=0; i<visArray.length; i++){    //with each visibility
    theVis = visArray[i];
    if (theVis) {      //if not empty
      theVis = (theVis == LABEL_DEFAULT)? "inherit" : ((theVis == LABEL_SHOW) ? "show" : "hide");
      layerObjNS = document.MM_NS_REFS[i]; //get layer name from list
      if (argList) argList += ",";    //if stuff already in list, add comma
      if (layerObjNS.indexOf(REF_UNNAMED) != 0) { //if real layer
        layerObjNS = getNameFromRef(layerObjNS);
        argList += "'"+layerObjNS+"','','"+theVis+"'";
      }
      else return MSG_UnnamedLayer;
    }
  }
  if (argList) {
    updateBehaviorFns("MM_findObj","MM_showHideLayers");
    retVal = "MM_showHideLayers("+argList+")";  //return fn call with args
  } else {
    retVal = MSG_NoLayersSet;
  }
  return retVal;
}



//Returns a dummy function call to inform Dreamweaver the type of certain behavior
//call arguments. This information is used by DW to fixup behavior args when the
//document is moved or changed.
//
//It is passed an actual function call string generated by applyBehavior(), which
//may have a variable list of arguments, and this should return a matching mask.
//
//The return values are:
//  URL     : argument could be a file path, which DW will update during Save As...
//  NS4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  IE4.0ref: arg is an object ref that may be changed by Convert Tables to Layers
//  other...: argument is ignored

function identifyBehaviorArguments(fnCallStr) {
  var argList, argArray, numArgGroups, i;

  argList = "";
  argArray = extractArgs(fnCallStr);
  numArgGroups = (argArray.length - 1) / 3; //args come in triplets
  for (i=0; i<numArgGroups; i++) {          //with NSobj,IEobj,vis triplet
    if (argList) argList += ",";
    argList += (argArray[3*i+1].indexOf(".")==-1)? "objName,other,other" : "NS4.0ref,IE4.0ref,other";
  }
  return argList;
}



//Given the original function call, this parses out the args and updates
//the UI. First it gets new layer,vis pairs.
//If layer already present in menu, stuff vis value in visArray. If layer
//doesn't exist, add to menu, and extend visArray.

function inspectBehavior(upStr){
  var argArray,visArray,found,numLayers,i,j,theLayerNS,theVis,layerNum;

  argArray = extractArgs(upStr);//get new list of layer,vis pairs
  visArray = document.MM_visArray; //get the prior list of layers
  numLayers = document.MM_NS_REFS.length;
  for (i=1; i<(argArray.length-2); i+=3){ //with each layerNS,layerIE,vis triplet (skip fn name)
    theLayerNS=argArray[i];
    theVis=argArray[i+2];
    theVis = (theVis == "inherit")? LABEL_DEFAULT : ((theVis == "show") ? LABEL_SHOW : LABEL_HIDE);
    found = false;
    for (j=0; j<numLayers; j++){  //check if layer is in menu
      if (theLayerNS == document.MM_NS_REFS[j] || theLayerNS == getNameFromRef(document.MM_NS_REFS[j])) { //if layer there
        visArray[j] = theVis;               //store vis at that pos
        addValueToMenuItem(document.theForm.menu,j,theVis);
        found = true;
        break;
      }
    }
    if (!found) alert(errMsg(MSG_LayerNotFound,theLayerNS,theVis));
  }
  document.MM_visArray = visArray; //save updated layer list
}



//***************** LOCAL FUNCTIONS  ******************


//Load the select menu with layer names.
//Also sets the global property MM_visArray to the right num of items.

function initializeUI(){
  var niceNameSrcArray, nameArray,visArray,i;

  document.MM_NS_REFS = getAllObjectRefs("NS 4.0","LAYER"); //store parallel NS refs
  document.MM_IE_REFS = getAllObjectRefs("IE 4.0","LAYER"); //store parallel IE refs
  niceNameSrcArray = document.MM_NS_REFS;

  //Search for unreferenceable objects. <DIV id="foo"> is IE only, <LAYER> is NS only.
  //if REF_CANNOT found, return empty string, and use IE refs for nice namelist.
  for (i=0; i<document.MM_NS_REFS.length; i++) {
    if (document.MM_IE_REFS[i].indexOf(REF_CANNOT) == 0) {
      document.MM_IE_REFS[i] = ""; //blank it out
    }
    if (document.MM_NS_REFS[i].indexOf(REF_CANNOT) == 0) {
      document.MM_NS_REFS[i] = ""; //blank it out
      niceNameSrcArray = document.MM_IE_REFS; //use the IE list
    }
  }
  nameArray = niceNames(niceNameSrcArray,TYPE_Layer);  //get layer names (includes CSS)

  visArray = new Array();     //start global list
  for (i=0; i<nameArray.length; i++) {
    document.theForm.menu.options[i]=new Option(nameArray[i]); //load menu
    visArray[i] = "";
  }
  document.MM_visArray = visArray; //set global
}



//Given radio selection, looks up the menu's selection number, and stores the
//new visiblity at that position in the global document property "MM_visArray".

function storeVis(newVis){
  var visArray, curLayerNum, oldVis;

  visArray = document.MM_visArray; //get the prior list of vis
  if (visArray){  // if anything to store on
    curLayerNum = document.theForm.menu.selectedIndex; //get index to swap
    oldVis = visArray[curLayerNum];
    if (oldVis != newVis) {
      visArray[curLayerNum] = newVis;   //swap
      document.MM_visArray = visArray;   //rewrite list
      addValueToMenuItem(document.theForm.menu, curLayerNum, newVis);
      document.theForm.menu.selectedIndex = curLayerNum; //reset selection index
    } else {  //same value, so toggle it (remove value)
      visArray[curLayerNum] = "";   //clear
      document.MM_visArray = visArray;   //rewrite list
      addValueToMenuItem(document.theForm.menu, curLayerNum, ""); //clear value from menu item
      document.theForm.menu.selectedIndex = curLayerNum; //reset selection index
    }
  }
}
